<?php
// Include the database connection file
require_once 'db.php';

// Set headers for JSON response
header('Content-Type: application/json');

try {
    // Execute query
    $result = $conn->query("SELECT * FROM siteseo WHERE delete_status = 0 AND mode = 1");
    
    if (!$result) {
        throw new Exception($conn->error);
    }
    
    // Fetch all results as associative array
    $results = [];
    while ($row = $result->fetch_assoc()) {
        $results[] = $row;
    }
    
    // Return the results as JSON
    echo json_encode([
        'success' => true,
        'data' => $results
    ]);
    
} catch(Exception $e) {
    // Handle errors
    echo json_encode([
        'success' => false,
        'message' => 'Database error: ' . $e->getMessage()
    ]);
}

// Close the connection
$conn->close();
?>